<?php
/**
 * ===================================================================================
 * Admin Logout Script
 * ===================================================================================
 *
 * File: logout.php
 * Location: /homework_portal/admin/logout.php
 *
 * Purpose:
 * 1. This is the specific logout script for the Admin Portal.
 * 2. It completely destroys the current session.
 * 3. It redirects the user back to the admin login page.
 */

// Start the session to gain access to it.
session_start();

// Unset all session variables to clear any stored data.
$_SESSION = array();

// Destroy the session from the server.
session_destroy();

// Redirect the user to the admin login page located in the same directory.
header('Location: login.php');
exit(); // Ensure no other code runs after the redirect.

?>
